from neuron import h
from neuron.units import um

class cell():
    
    """
    Rewrite here if you want to change parameters
    """
    
    """Geometry"""
    NofSection = 13 #Number of sections in the main stem
    medial_border = 5 #Medial area start from this section, must be >=2
    clc2_border = 8 #Distal area starts from this section

    BranchConnectPoint = 8 #From where branch bifurcates
    NofBranches = 2 #Number of branches, 0 then no branch is generated
    NofSecinBranches = 3 #Number of sections in a single branch

    L_soma = 30 #um
    diam_soma = 30
    L_proxi = 50 #each proximal section will be L_proxi um
    diam_proxi_start = 3 #diam linearly changes from diam_proxi_start to diam_medial through whole proximal area
    L_medial = 50
    diam_medial = 0.5
    L_dist = 30
    diam_dist = 0.5
    L_branch = 30
    diam_branch = 0.5

    """electrical property"""
    cm = 0.8 #uF/cm2
    Ra = 250 #Ohm*cm

    """ion concentration"""
    Nai0 = 10 #mM
    Nao0 = 120
    Ki0 = 125
    Ko0 = 5
    
    Cli0_soma = 10 #Cl conc at soma
    Cli0_dendterm = 4.5 #Cl conc at "distal" & "branches"
    Clo0 = 126   

    """leak"""
    leak_gradual = 1 
    #If 1, gionleak linearly change through proximal & medial area. If 0, gionleak will change uncontinuously between "medial" and "distal"
    
    #soma
    gnaleak_p = 0.50e-05 #S/cm2
    gkleak_p = 4.0e-05
    gclleak_p = 0.10e-05
    #distal
    gnaleak_d = 0.50e-05
    gkleak_d = 4.0e-05
    gclleak_d = 0.10e-05

    """NaKpump"""
    NaKpump_gradual = 1
    
    #soma
    Imaxpump_p = 0.006 #mA/cm2
    #distal
    Imaxpump_d = 0.006

    """KCC2"""
    KCC2_gradual = 1
    
    #soma
    UKCC2_p = 0.0002 #mA/cm2
    #distal
    UKCC2_d = 0.0002

    """ClC-2 like channel"""
    ClC2_gradual = 1 # only gbar is supposed to change gradually
    
    #soma
    gbarClC2_p = 3.0e-05 #S/cm2
    VhClC2_p = -75 #mV
    VsClC2_p = 6 #mV
    tauClC2_p = 10 #ms
    #distal
    gbarClC2_d = 12.0e-05
    VhClC2_d = -75
    VsClC2_d = 6
    tauClC2_d = 10

    """TTX-R Nav"""
    Nav_gradual = 1
    
    #soma
    gbarNav_p = 5.0e-05 #S/cm2
    #distal
    gbarNav_d =7.5e-05



    
    """
    No need to edit under here
    """
    def setup(self):
        """main stem"""
        self.dend = [0] * self.NofSection

        for i in range(0,self.NofSection):
            """Geometry"""
            if i == 0: #soma
                self.dend[i] = h.Section(name="soma")
                self.dend[i].L = self.L_soma *um
                self.dend[i].diam = self.diam_soma *um
                self.dend[i].nseg = 11
            elif i < self.medial_border: #proximal stem
                self.dend[i] = h.Section(name="dend"+str(i))
                self.dend[i].L = self.L_proxi * um
                self.dend[i].diam = (self.diam_proxi_start - (self.diam_proxi_start-self.diam_medial)*((i-1)/(self.medial_border-1))) * um
                self.dend[i].nseg = 11
            elif i < self.clc2_border: #medial stem
                self.dend[i] = h.Section(name="dend"+str(i))
                self.dend[i].L = self.L_medial * um
                self.dend[i].diam = self.diam_medial * um
                self.dend[i].nseg = 11
            else: #distal stem
                self.dend[i] = h.Section(name="dend"+str(i))
                self.dend[i].L = self.L_dist *um
                self.dend[i].diam = self.diam_dist *um
                self.dend[i].nseg = 11
                
            if i != 0:
                self.dend[i].connect(self.dend[i-1])
            
            """Electical properties"""
            self.dend[i].cm = self.cm
            self.dend[i].Ra = self.Ra
            
            """"Mechanisms"""
            
            soma2distbord = self.L_proxi*(self.medial_border-1) + self.L_medial*(self.clc2_border-self.medial_border)
            
            if i < self.clc2_border: #soma & proximal & medial
                self.dend[i].insert("leak")
                if self.leak_gradual == 1:
                    slope_na = (self.gnaleak_d - self.gnaleak_p)/soma2distbord
                    slope_k = (self.gkleak_d - self.gkleak_p)/soma2distbord
                    slope_cl = (self.gclleak_d - self.gclleak_p)/soma2distbord
                    if i == 0:
                        self.dend[i].gna_leak = self.gnaleak_p
                        self.dend[i].gk_leak = self.gkleak_p
                        self.dend[i].gcl_leak = self.gclleak_p
                    elif i < self.medial_border:
                        dist_from_soma =  self.L_proxi * (float(i) - 0.5)
                        self.dend[i].gna_leak = self.gnaleak_p + slope_na * dist_from_soma
                        self.dend[i].gk_leak = self.gkleak_p + slope_k * dist_from_soma
                        self.dend[i].gcl_leak = self.gclleak_p + slope_cl * dist_from_soma
                    else:
                        dist_from_soma =  self.L_proxi * (self.medial_border-1) + self.L_medial* (float(i)-self.medial_border+0.5)
                        self.dend[i].gna_leak = self.gnaleak_p + slope_na * dist_from_soma
                        self.dend[i].gk_leak = self.gkleak_p + slope_k * dist_from_soma
                        self.dend[i].gcl_leak = self.gclleak_p + slope_cl * dist_from_soma
                else:
                    self.dend[i].gna_leak = self.gnaleak_p
                    self.dend[i].gk_leak = self.gkleak_p
                    self.dend[i].gcl_leak = self.gclleak_p
    
                self.dend[i].insert("NaKpump")
                if self.NaKpump_gradual == 1:
                    slope = (self.Imaxpump_d - self.Imaxpump_p)/soma2distbord
                    if i == 0:
                        self.dend[i].imax_NaKpump = self.Imaxpump_p
                    elif i < self.medial_border:
                        dist_from_soma =  self.L_proxi * (float(i) - 0.5)
                        self.dend[i].imax_NaKpump = self.Imaxpump_p + slope * dist_from_soma
                    else:
                        dist_from_soma =  self.L_proxi * (self.medial_border-1) + self.L_medial* (float(i)-self.medial_border+0.5)
                        self.dend[i].imax_NaKpump = self.Imaxpump_p + slope * dist_from_soma
                else:
                    self.dend[i].imax_NaKpump = self.Imaxpump_p

                self.dend[i].insert("KCC2")
                if self.KCC2_gradual == 1:
                    slope = (self.UKCC2_d - self.UKCC2_p)/soma2distbord
                    if i == 0:
                        self.dend[i].U_KCC2 = self.UKCC2_p
                    elif i < self.medial_border:
                        dist_from_soma =  self.L_proxi * (float(i) - 0.5)
                        self.dend[i].U_KCC2 = self.UKCC2_p + slope * dist_from_soma
                    else:
                        dist_from_soma =  self.L_proxi * (self.medial_border-1) + self.L_medial* (float(i)-self.medial_border+0.5)
                        self.dend[i].U_KCC2 = self.UKCC2_p + slope * dist_from_soma
                else:
                    self.dend[i].U_KCC2 = self.UKCC2_p

                self.dend[i].insert("ClC2")
                self.dend[i].vh_ClC2 = self.VhClC2_p
                self.dend[i].vs_ClC2 = self.VsClC2_p
                self.dend[i].tau_ClC2 = self.tauClC2_p
                if self.ClC2_gradual == 1:
                    slope = (self.gbarClC2_d - self.gbarClC2_p)/soma2distbord
                    if i == 0:
                        self.dend[i].gbar_ClC2 = self.gbarClC2_p
                    elif i < self.medial_border:
                        dist_from_soma =  self.L_proxi * (float(i) - 0.5)
                        self.dend[i].gbar_ClC2 = self.gbarClC2_p + slope * dist_from_soma
                    else:
                        dist_from_soma =  self.L_proxi * (self.medial_border-1) + self.L_medial* (float(i)-self.medial_border+0.5)
                        self.dend[i].gbar_ClC2 = self.gbarClC2_p + slope * dist_from_soma
                else:
                    self.dend[i].gbar_ClC2 = self.gbarClC2_p
                
                self.dend[i].insert("TTXRNa")
                if self.Nav_gradual == 1:
                    slope = (self.gbarNav_d - self.gbarNav_p)/soma2distbord
                    if i == 0:
                        self.dend[i].gnabar_TTXRNa = self.gbarNav_p
                    elif i < self.medial_border:
                        dist_from_soma =  self.L_proxi * (float(i) - 0.5)
                        self.dend[i].gnabar_TTXRNa = self.gbarNav_p + slope * dist_from_soma
                    else:
                        dist_from_soma =  self.L_proxi * (self.medial_border-1) + self.L_medial* (float(i)-self.medial_border+0.5)
                        self.dend[i].gnabar_TTXRNa = self.gbarNav_p + slope * dist_from_soma
                else:
                    self.dend[i].gnabar_TTXRNa = self.gbarNav_p
                
            else: #distal
                self.dend[i].insert("leak")
                self.dend[i].gna_leak = self.gnaleak_d
                self.dend[i].gk_leak = self.gkleak_d
                self.dend[i].gcl_leak = self.gclleak_d
                  
                self.dend[i].insert("NaKpump")
                self.dend[i].imax_NaKpump = self.Imaxpump_d

                self.dend[i].insert("KCC2")
                self.dend[i].U_KCC2 = self.UKCC2_d
                
                self.dend[i].insert("ClC2")
                self.dend[i].gbar_ClC2 = self.gbarClC2_d
                self.dend[i].vh_ClC2 = self.VhClC2_d
                self.dend[i].vs_ClC2 = self.VsClC2_d
                self.dend[i].tau_ClC2 = self.tauClC2_d
                
                self.dend[i].insert("TTXRNa")
                self.dend[i].gnabar_TTXRNa = self.gbarNav_d

        """branch"""
        self.branch = [0]*self.NofBranches

        for i in range (0,self.NofBranches):
            
            self.branch[i] = [0]*self.NofSecinBranches
            
            for j in range(0,self.NofSecinBranches):
                """Geometry"""
                self.branch[i][j] = h.Section(name="branch"+str(i+1)+"-"+str(j+1))
                self.branch[i][j].L = self.L_branch *um
                self.branch[i][j].diam = self.diam_branch *um
                self.branch[i][j].nseg = 11
                
                if j == 0:
                    self.branch[i][j].connect(self.dend[self.BranchConnectPoint])
                else:
                    self.branch[i][j].connect(self.branch[i][j-1])
                
                """Electrical properties"""
                self.branch[i][j].cm = self.cm
                self.branch[i][j].Ra = self.Ra
                
                """Mechanisms"""
                self.branch[i][j].insert("leak")
                self.branch[i][j].gna_leak = self.gnaleak_d
                self.branch[i][j].gk_leak = self.gkleak_d
                self.branch[i][j].gcl_leak = self.gclleak_d
                
                self.branch[i][j].insert("NaKpump")
                self.branch[i][j].imax_NaKpump = self.Imaxpump_d
                    
                self.branch[i][j].insert("KCC2")
                self.branch[i][j].U_KCC2 = self.UKCC2_d
                
                self.branch[i][j].insert("ClC2")
                self.branch[i][j].gbar_ClC2 = self.gbarClC2_d
                self.branch[i][j].vh_ClC2 = self.VhClC2_d
                self.branch[i][j].vs_ClC2 = self.VsClC2_d
                self.branch[i][j].tau_ClC2 = self.tauClC2_d
                
                self.branch[i][j].insert("TTXRNa")
                self.branch[i][j].gnabar_TTXRNa = self.gbarNav_d
                
    def initialize_ion(self):

        soma2distbord = self.L_proxi*(self.medial_border-1) + self.L_medial*(self.clc2_border-self.medial_border)
        
        for i in range(0,self.NofSection):
            self.dend[i].nai = self.Nai0
            self.dend[i].nao = self.Nao0
            self.dend[i].ki = self.Ki0
            self.dend[i].ko = self.Ko0
            self.dend[i].clo = self.Clo0
            
            if i == 0:
                self.dend[i].cli = self.Cli0_soma
            elif i < self.medial_border:
                dist_from_soma =  self.L_proxi * (float(i) - 0.5)
                self.dend[i].cli = self.Cli0_soma + ((self.Cli0_dendterm - self.Cli0_soma)/soma2distbord) * dist_from_soma
            elif i < self.clc2_border:
                dist_from_soma =  self.L_proxi * (self.medial_border-1) + self.L_medial* (float(i)-self.medial_border+0.5)
                self.dend[i].cli = self.Cli0_soma + ((self.Cli0_dendterm - self.Cli0_soma)/soma2distbord) * dist_from_soma
            else:
                self.dend[i].cli = self.Cli0_dendterm
        
        for i in range(0,self.NofBranches):
            for j in range(0,self.NofSecinBranches):
                self.branch[i][j].nai = self.Nai0
                self.branch[i][j].nao = self.Nao0
                self.branch[i][j].ki = self.Ki0
                self.branch[i][j].ko = self.Ko0
                self.branch[i][j].cli = self.Cli0_dendterm
                self.branch[i][j].clo = self.Clo0
                
            
