COMMENT
Hyperpolarization-activated voltage sensitive chloride channel (ClC-2 like channel).
Modified from Ratte and Prescott, 2011. 
ENDCOMMENT

NEURON{
    SUFFIX ClC2
    USEION cl READ ecl WRITE icl VALENCE -1
    RANGE icl, minf, gbar, vh, vs, tau, m
}

UNITS{
    (S) = (siemens)
    (mV) = (millivolt)
    (mA) = (milliamp)
}

PARAMETER{
    gbar = 12.0e-5 (S/cm2)
    vh = -75 (mV)
    vs = 6 (mV)
    tau = 10 (ms)
}

ASSIGNED{
    v (mV)
    ecl (mV)
    icl (mA/cm2)
    minf (1)
}

STATE{
    m
}

INITIAL{
    m = steady(v,vh,vs)
}

BREAKPOINT{
    SOLVE state METHOD cnexp
    icl = gbar * m * (v - ecl)
}

DERIVATIVE state{
    minf = steady(v,vh,vs)
    m' = -(m - minf)/tau
}

FUNCTION steady(v(mV), vh(mV), vs(mV)) (1) {
    UNITSOFF
    steady = 1 / (1 + exp((v-vh)/vs))
    UNITSON
}