COMMENT
Potassium and chloride symporter KCC2
from Gentiletti et al., 2022. 
ENDCOMMENT

NEURON{
    SUFFIX KCC2
    USEION k READ ki, ko WRITE ik
    USEION cl READ cli, clo WRITE icl VALENCE -1
    RANGE ik,U
}

UNITS{
    (mA) = (milliamp)
    (molar) = (1/liter)
    (mM) = (millimolar)
}

PARAMETER{
    U = 0.0002 (mA/cm2) 
}

ASSIGNED{
    ik (mA/cm2)
    icl (mA/cm2)
    ki (mM)
    ko (mM)
    cli (mM)
    clo (mM)
}

BREAKPOINT{
    LOCAL rate
    rate = U * log((ki * cli)/(ko * clo))
    ik = rate
    icl = -rate
}