/* Created by Language version: 7.7.0 */
/* VECTORIZED */
#define NRN_VECTORIZED 1
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "mech_api.h"
#undef PI
#define nil 0
#include "md1redef.h"
#include "section.h"
#include "nrniv_mf.h"
#include "md2redef.h"
 
#if METHOD3
extern int _method3;
#endif

#if !NRNGPU
#undef exp
#define exp hoc_Exp
extern double hoc_Exp(double);
#endif
 
#define nrn_init _nrn_init__TTXRNa
#define _nrn_initial _nrn_initial__TTXRNa
#define nrn_cur _nrn_cur__TTXRNa
#define _nrn_current _nrn_current__TTXRNa
#define nrn_jacob _nrn_jacob__TTXRNa
#define nrn_state _nrn_state__TTXRNa
#define _net_receive _net_receive__TTXRNa 
#define rates rates__TTXRNa 
#define state state__TTXRNa 
 
#define _threadargscomma_ _p, _ppvar, _thread, _nt,
#define _threadargsprotocomma_ double* _p, Datum* _ppvar, Datum* _thread, NrnThread* _nt,
#define _threadargs_ _p, _ppvar, _thread, _nt
#define _threadargsproto_ double* _p, Datum* _ppvar, Datum* _thread, NrnThread* _nt
 	/*SUPPRESS 761*/
	/*SUPPRESS 762*/
	/*SUPPRESS 763*/
	/*SUPPRESS 765*/
	 extern double *getarg();
 /* Thread safe. No static _p or _ppvar. */
 
#define t _nt->_t
#define dt _nt->_dt
#define gnabar _p[0]
#define gnabar_columnindex 0
#define A_am9 _p[1]
#define A_am9_columnindex 1
#define B_am9 _p[2]
#define B_am9_columnindex 2
#define C_am9 _p[3]
#define C_am9_columnindex 3
#define A_bm9 _p[4]
#define A_bm9_columnindex 4
#define B_bm9 _p[5]
#define B_bm9_columnindex 5
#define C_bm9 _p[6]
#define C_bm9_columnindex 6
#define A_ah9 _p[7]
#define A_ah9_columnindex 7
#define B_ah9 _p[8]
#define B_ah9_columnindex 8
#define C_ah9 _p[9]
#define C_ah9_columnindex 9
#define A_bh9 _p[10]
#define A_bh9_columnindex 10
#define B_bh9 _p[11]
#define B_bh9_columnindex 11
#define C_bh9 _p[12]
#define C_bh9_columnindex 12
#define ina _p[13]
#define ina_columnindex 13
#define mn _p[14]
#define mn_columnindex 14
#define hn _p[15]
#define hn_columnindex 15
#define ena _p[16]
#define ena_columnindex 16
#define gna _p[17]
#define gna_columnindex 17
#define tau_mn _p[18]
#define tau_mn_columnindex 18
#define tau_hn _p[19]
#define tau_hn_columnindex 19
#define mninf _p[20]
#define mninf_columnindex 20
#define hninf _p[21]
#define hninf_columnindex 21
#define Dmn _p[22]
#define Dmn_columnindex 22
#define Dhn _p[23]
#define Dhn_columnindex 23
#define v _p[24]
#define v_columnindex 24
#define _g _p[25]
#define _g_columnindex 25
#define _ion_ena	*_ppvar[0]._pval
#define _ion_ina	*_ppvar[1]._pval
#define _ion_dinadv	*_ppvar[2]._pval
 
#if MAC
#if !defined(v)
#define v _mlhv
#endif
#if !defined(h)
#define h _mlhh
#endif
#endif
 
#if defined(__cplusplus)
extern "C" {
#endif
 static int hoc_nrnpointerindex =  -1;
 static Datum* _extcall_thread;
 static Prop* _extcall_prop;
 /* external NEURON variables */
 /* declaration of user functions */
 static void _hoc_alphah(void);
 static void _hoc_alpham(void);
 static void _hoc_betah(void);
 static void _hoc_betam(void);
 static void _hoc_rates(void);
 static int _mechtype;
extern void _nrn_cacheloop_reg(int, int);
extern void hoc_register_prop_size(int, int, int);
extern void hoc_register_limits(int, HocParmLimits*);
extern void hoc_register_units(int, HocParmUnits*);
extern void nrn_promote(Prop*, int, int);
extern Memb_func* memb_func;
 
#define NMODL_TEXT 1
#if NMODL_TEXT
static const char* nmodl_file_text;
static const char* nmodl_filename;
extern void hoc_reg_nmodl_text(int, const char*);
extern void hoc_reg_nmodl_filename(int, const char*);
#endif

 extern void _nrn_setdata_reg(int, void(*)(Prop*));
 static void _setdata(Prop* _prop) {
 _extcall_prop = _prop;
 }
 static void _hoc_setdata() {
 Prop *_prop, *hoc_getdata_range(int);
 _prop = hoc_getdata_range(_mechtype);
   _setdata(_prop);
 hoc_retpushx(1.);
}
 /* connect user functions to hoc names */
 static VoidFunc hoc_intfunc[] = {
 "setdata_TTXRNa", _hoc_setdata,
 "alphah_TTXRNa", _hoc_alphah,
 "alpham_TTXRNa", _hoc_alpham,
 "betah_TTXRNa", _hoc_betah,
 "betam_TTXRNa", _hoc_betam,
 "rates_TTXRNa", _hoc_rates,
 0, 0
};
#define alphah alphah_TTXRNa
#define alpham alpham_TTXRNa
#define betah betah_TTXRNa
#define betam betam_TTXRNa
 extern double alphah( _threadargsprotocomma_ double );
 extern double alpham( _threadargsprotocomma_ double );
 extern double betah( _threadargsprotocomma_ double );
 extern double betam( _threadargsprotocomma_ double );
 /* declare global and static user variables */
 /* some parameters have upper and lower limits */
 static HocParmLimits _hoc_parm_limits[] = {
 0,0,0
};
 static HocParmUnits _hoc_parm_units[] = {
 "gnabar_TTXRNa", "S/cm2",
 "A_am9_TTXRNa", "/ms",
 "B_am9_TTXRNa", "mV",
 "C_am9_TTXRNa", "mV",
 "A_bm9_TTXRNa", "/ms",
 "B_bm9_TTXRNa", "mV",
 "C_bm9_TTXRNa", "mV",
 "A_ah9_TTXRNa", "/ms",
 "B_ah9_TTXRNa", "mV",
 "C_ah9_TTXRNa", "mV",
 "A_bh9_TTXRNa", "/ms",
 "B_bh9_TTXRNa", "mV",
 "C_bh9_TTXRNa", "mV",
 "ina_TTXRNa", "mA/cm2",
 0,0
};
 static double delta_t = 0.01;
 static double hn0 = 0;
 static double mn0 = 0;
 /* connect global user variables to hoc */
 static DoubScal hoc_scdoub[] = {
 0,0
};
 static DoubVec hoc_vdoub[] = {
 0,0,0
};
 static double _sav_indep;
 static void nrn_alloc(Prop*);
static void  nrn_init(NrnThread*, _Memb_list*, int);
static void nrn_state(NrnThread*, _Memb_list*, int);
 static void nrn_cur(NrnThread*, _Memb_list*, int);
static void  nrn_jacob(NrnThread*, _Memb_list*, int);
 
static int _ode_count(int);
static void _ode_map(int, double**, double**, double*, Datum*, double*, int);
static void _ode_spec(NrnThread*, _Memb_list*, int);
static void _ode_matsol(NrnThread*, _Memb_list*, int);
 
#define _cvode_ieq _ppvar[3]._i
 static void _ode_matsol_instance1(_threadargsproto_);
 /* connect range variables in _p that hoc is supposed to know about */
 static const char *_mechanism[] = {
 "7.7.0",
"TTXRNa",
 "gnabar_TTXRNa",
 "A_am9_TTXRNa",
 "B_am9_TTXRNa",
 "C_am9_TTXRNa",
 "A_bm9_TTXRNa",
 "B_bm9_TTXRNa",
 "C_bm9_TTXRNa",
 "A_ah9_TTXRNa",
 "B_ah9_TTXRNa",
 "C_ah9_TTXRNa",
 "A_bh9_TTXRNa",
 "B_bh9_TTXRNa",
 "C_bh9_TTXRNa",
 0,
 "ina_TTXRNa",
 0,
 "mn_TTXRNa",
 "hn_TTXRNa",
 0,
 0};
 static Symbol* _na_sym;
 
extern Prop* need_memb(Symbol*);

static void nrn_alloc(Prop* _prop) {
	Prop *prop_ion;
	double *_p; Datum *_ppvar;
 	_p = nrn_prop_data_alloc(_mechtype, 26, _prop);
 	/*initialize range parameters*/
 	gnabar = 7.5e-05;
 	A_am9 = 1.032;
 	B_am9 = 6.99;
 	C_am9 = -14.8712;
 	A_bm9 = 5.79;
 	B_bm9 = 130.4;
 	C_bm9 = 22.9;
 	A_ah9 = 0.06435;
 	B_ah9 = 73.2642;
 	C_ah9 = 3.71928;
 	A_bh9 = 0.13496;
 	B_bh9 = 10.2785;
 	C_bh9 = -9.09334;
 	_prop->param = _p;
 	_prop->param_size = 26;
 	_ppvar = nrn_prop_datum_alloc(_mechtype, 4, _prop);
 	_prop->dparam = _ppvar;
 	/*connect ionic variables to this model*/
 prop_ion = need_memb(_na_sym);
 nrn_promote(prop_ion, 0, 1);
 	_ppvar[0]._pval = &prop_ion->param[0]; /* ena */
 	_ppvar[1]._pval = &prop_ion->param[3]; /* ina */
 	_ppvar[2]._pval = &prop_ion->param[4]; /* _ion_dinadv */
 
}
 static void _initlists();
  /* some states have an absolute tolerance */
 static Symbol** _atollist;
 static HocStateTolerance _hoc_state_tol[] = {
 0,0
};
 static void _update_ion_pointer(Datum*);
 extern Symbol* hoc_lookup(const char*);
extern void _nrn_thread_reg(int, int, void(*)(Datum*));
extern void _nrn_thread_table_reg(int, void(*)(double*, Datum*, Datum*, NrnThread*, int));
extern void hoc_register_tolerance(int, HocStateTolerance*, Symbol***);
extern void _cvode_abstol( Symbol**, double*, int);

 void _Nav_reg() {
	int _vectorized = 1;
  _initlists();
 	ion_reg("na", -10000.);
 	_na_sym = hoc_lookup("na_ion");
 	register_mech(_mechanism, nrn_alloc,nrn_cur, nrn_jacob, nrn_state, nrn_init, hoc_nrnpointerindex, 1);
 _mechtype = nrn_get_mechtype(_mechanism[1]);
     _nrn_setdata_reg(_mechtype, _setdata);
     _nrn_thread_reg(_mechtype, 2, _update_ion_pointer);
 #if NMODL_TEXT
  hoc_reg_nmodl_text(_mechtype, nmodl_file_text);
  hoc_reg_nmodl_filename(_mechtype, nmodl_filename);
#endif
  hoc_register_prop_size(_mechtype, 26, 4);
  hoc_register_dparam_semantics(_mechtype, 0, "na_ion");
  hoc_register_dparam_semantics(_mechtype, 1, "na_ion");
  hoc_register_dparam_semantics(_mechtype, 2, "na_ion");
  hoc_register_dparam_semantics(_mechtype, 3, "cvodeieq");
 	hoc_register_cvode(_mechtype, _ode_count, _ode_map, _ode_spec, _ode_matsol);
 	hoc_register_tolerance(_mechtype, _hoc_state_tol, &_atollist);
 	hoc_register_var(hoc_scdoub, hoc_vdoub, hoc_intfunc);
 	ivoc_help("help ?1 TTXRNa Nav.mod\n");
 hoc_register_limits(_mechtype, _hoc_parm_limits);
 hoc_register_units(_mechtype, _hoc_parm_units);
 }
static int _reset;
static char *modelname = "";

static int error;
static int _ninits = 0;
static int _match_recurse=1;
static void _modl_cleanup(){ _match_recurse=1;}
static int rates(_threadargsprotocomma_ double);
 
static int _ode_spec1(_threadargsproto_);
/*static int _ode_matsol1(_threadargsproto_);*/
 static int _slist1[2], _dlist1[2];
 static int state(_threadargsproto_);
 
/*CVODE*/
 static int _ode_spec1 (double* _p, Datum* _ppvar, Datum* _thread, NrnThread* _nt) {int _reset = 0; {
   rates ( _threadargscomma_ v ) ;
   Dmn = ( mninf - mn ) / tau_mn ;
   Dhn = ( hninf - hn ) / tau_hn ;
   }
 return _reset;
}
 static int _ode_matsol1 (double* _p, Datum* _ppvar, Datum* _thread, NrnThread* _nt) {
 rates ( _threadargscomma_ v ) ;
 Dmn = Dmn  / (1. - dt*( ( ( ( - 1.0 ) ) ) / tau_mn )) ;
 Dhn = Dhn  / (1. - dt*( ( ( ( - 1.0 ) ) ) / tau_hn )) ;
  return 0;
}
 /*END CVODE*/
 static int state (double* _p, Datum* _ppvar, Datum* _thread, NrnThread* _nt) { {
   rates ( _threadargscomma_ v ) ;
    mn = mn + (1. - exp(dt*(( ( ( - 1.0 ) ) ) / tau_mn)))*(- ( ( ( mninf ) ) / tau_mn ) / ( ( ( ( - 1.0 ) ) ) / tau_mn ) - mn) ;
    hn = hn + (1. - exp(dt*(( ( ( - 1.0 ) ) ) / tau_hn)))*(- ( ( ( hninf ) ) / tau_hn ) / ( ( ( ( - 1.0 ) ) ) / tau_hn ) - hn) ;
   }
  return 0;
}
 
double alpham ( _threadargsprotocomma_ double _lVm ) {
   double _lalpham;
 _lalpham = A_am9 / ( 1.0 + exp ( ( _lVm + B_am9 ) / C_am9 ) ) ;
   
return _lalpham;
 }
 
static void _hoc_alpham(void) {
  double _r;
   double* _p; Datum* _ppvar; Datum* _thread; NrnThread* _nt;
   if (_extcall_prop) {_p = _extcall_prop->param; _ppvar = _extcall_prop->dparam;}else{ _p = (double*)0; _ppvar = (Datum*)0; }
  _thread = _extcall_thread;
  _nt = nrn_threads;
 _r =  alpham ( _p, _ppvar, _thread, _nt, *getarg(1) );
 hoc_retpushx(_r);
}
 
double betam ( _threadargsprotocomma_ double _lVm ) {
   double _lbetam;
 _lbetam = A_bm9 / ( 1.0 + exp ( ( _lVm + B_bm9 ) / C_bm9 ) ) ;
   
return _lbetam;
 }
 
static void _hoc_betam(void) {
  double _r;
   double* _p; Datum* _ppvar; Datum* _thread; NrnThread* _nt;
   if (_extcall_prop) {_p = _extcall_prop->param; _ppvar = _extcall_prop->dparam;}else{ _p = (double*)0; _ppvar = (Datum*)0; }
  _thread = _extcall_thread;
  _nt = nrn_threads;
 _r =  betam ( _p, _ppvar, _thread, _nt, *getarg(1) );
 hoc_retpushx(_r);
}
 
double alphah ( _threadargsprotocomma_ double _lVm ) {
   double _lalphah;
 _lalphah = A_ah9 / ( 1.0 + exp ( ( _lVm + B_ah9 ) / C_ah9 ) ) ;
   
return _lalphah;
 }
 
static void _hoc_alphah(void) {
  double _r;
   double* _p; Datum* _ppvar; Datum* _thread; NrnThread* _nt;
   if (_extcall_prop) {_p = _extcall_prop->param; _ppvar = _extcall_prop->dparam;}else{ _p = (double*)0; _ppvar = (Datum*)0; }
  _thread = _extcall_thread;
  _nt = nrn_threads;
 _r =  alphah ( _p, _ppvar, _thread, _nt, *getarg(1) );
 hoc_retpushx(_r);
}
 
double betah ( _threadargsprotocomma_ double _lVm ) {
   double _lbetah;
 _lbetah = A_bh9 / ( 1.0 + exp ( ( _lVm + B_bh9 ) / C_bh9 ) ) ;
   
return _lbetah;
 }
 
static void _hoc_betah(void) {
  double _r;
   double* _p; Datum* _ppvar; Datum* _thread; NrnThread* _nt;
   if (_extcall_prop) {_p = _extcall_prop->param; _ppvar = _extcall_prop->dparam;}else{ _p = (double*)0; _ppvar = (Datum*)0; }
  _thread = _extcall_thread;
  _nt = nrn_threads;
 _r =  betah ( _p, _ppvar, _thread, _nt, *getarg(1) );
 hoc_retpushx(_r);
}
 
static int  rates ( _threadargsprotocomma_ double _lVm ) {
   tau_mn = 1.0 / ( alpham ( _threadargscomma_ _lVm ) + betam ( _threadargscomma_ _lVm ) ) ;
   mninf = alpham ( _threadargscomma_ _lVm ) * tau_mn ;
   tau_hn = 1.0 / ( alphah ( _threadargscomma_ _lVm ) + betah ( _threadargscomma_ _lVm ) ) ;
   hninf = alphah ( _threadargscomma_ _lVm ) * tau_hn ;
    return 0; }
 
static void _hoc_rates(void) {
  double _r;
   double* _p; Datum* _ppvar; Datum* _thread; NrnThread* _nt;
   if (_extcall_prop) {_p = _extcall_prop->param; _ppvar = _extcall_prop->dparam;}else{ _p = (double*)0; _ppvar = (Datum*)0; }
  _thread = _extcall_thread;
  _nt = nrn_threads;
 _r = 1.;
 rates ( _p, _ppvar, _thread, _nt, *getarg(1) );
 hoc_retpushx(_r);
}
 
static int _ode_count(int _type){ return 2;}
 
static void _ode_spec(NrnThread* _nt, _Memb_list* _ml, int _type) {
   double* _p; Datum* _ppvar; Datum* _thread;
   Node* _nd; double _v; int _iml, _cntml;
  _cntml = _ml->_nodecount;
  _thread = _ml->_thread;
  for (_iml = 0; _iml < _cntml; ++_iml) {
    _p = _ml->_data[_iml]; _ppvar = _ml->_pdata[_iml];
    _nd = _ml->_nodelist[_iml];
    v = NODEV(_nd);
  ena = _ion_ena;
     _ode_spec1 (_p, _ppvar, _thread, _nt);
  }}
 
static void _ode_map(int _ieq, double** _pv, double** _pvdot, double* _pp, Datum* _ppd, double* _atol, int _type) { 
	double* _p; Datum* _ppvar;
 	int _i; _p = _pp; _ppvar = _ppd;
	_cvode_ieq = _ieq;
	for (_i=0; _i < 2; ++_i) {
		_pv[_i] = _pp + _slist1[_i];  _pvdot[_i] = _pp + _dlist1[_i];
		_cvode_abstol(_atollist, _atol, _i);
	}
 }
 
static void _ode_matsol_instance1(_threadargsproto_) {
 _ode_matsol1 (_p, _ppvar, _thread, _nt);
 }
 
static void _ode_matsol(NrnThread* _nt, _Memb_list* _ml, int _type) {
   double* _p; Datum* _ppvar; Datum* _thread;
   Node* _nd; double _v; int _iml, _cntml;
  _cntml = _ml->_nodecount;
  _thread = _ml->_thread;
  for (_iml = 0; _iml < _cntml; ++_iml) {
    _p = _ml->_data[_iml]; _ppvar = _ml->_pdata[_iml];
    _nd = _ml->_nodelist[_iml];
    v = NODEV(_nd);
  ena = _ion_ena;
 _ode_matsol_instance1(_threadargs_);
 }}
 extern void nrn_update_ion_pointer(Symbol*, Datum*, int, int);
 static void _update_ion_pointer(Datum* _ppvar) {
   nrn_update_ion_pointer(_na_sym, _ppvar, 0, 0);
   nrn_update_ion_pointer(_na_sym, _ppvar, 1, 3);
   nrn_update_ion_pointer(_na_sym, _ppvar, 2, 4);
 }

static void initmodel(double* _p, Datum* _ppvar, Datum* _thread, NrnThread* _nt) {
  int _i; double _save;{
  hn = hn0;
  mn = mn0;
 {
   rates ( _threadargscomma_ v ) ;
   mn = mninf ;
   hn = hninf ;
   }
 
}
}

static void nrn_init(NrnThread* _nt, _Memb_list* _ml, int _type){
double* _p; Datum* _ppvar; Datum* _thread;
Node *_nd; double _v; int* _ni; int _iml, _cntml;
#if CACHEVEC
    _ni = _ml->_nodeindices;
#endif
_cntml = _ml->_nodecount;
_thread = _ml->_thread;
for (_iml = 0; _iml < _cntml; ++_iml) {
 _p = _ml->_data[_iml]; _ppvar = _ml->_pdata[_iml];
#if CACHEVEC
  if (use_cachevec) {
    _v = VEC_V(_ni[_iml]);
  }else
#endif
  {
    _nd = _ml->_nodelist[_iml];
    _v = NODEV(_nd);
  }
 v = _v;
  ena = _ion_ena;
 initmodel(_p, _ppvar, _thread, _nt);
 }
}

static double _nrn_current(double* _p, Datum* _ppvar, Datum* _thread, NrnThread* _nt, double _v){double _current=0.;v=_v;{ {
   ina = gnabar * mn * hn * ( v - ena ) ;
   }
 _current += ina;

} return _current;
}

static void nrn_cur(NrnThread* _nt, _Memb_list* _ml, int _type) {
double* _p; Datum* _ppvar; Datum* _thread;
Node *_nd; int* _ni; double _rhs, _v; int _iml, _cntml;
#if CACHEVEC
    _ni = _ml->_nodeindices;
#endif
_cntml = _ml->_nodecount;
_thread = _ml->_thread;
for (_iml = 0; _iml < _cntml; ++_iml) {
 _p = _ml->_data[_iml]; _ppvar = _ml->_pdata[_iml];
#if CACHEVEC
  if (use_cachevec) {
    _v = VEC_V(_ni[_iml]);
  }else
#endif
  {
    _nd = _ml->_nodelist[_iml];
    _v = NODEV(_nd);
  }
  ena = _ion_ena;
 _g = _nrn_current(_p, _ppvar, _thread, _nt, _v + .001);
 	{ double _dina;
  _dina = ina;
 _rhs = _nrn_current(_p, _ppvar, _thread, _nt, _v);
  _ion_dinadv += (_dina - ina)/.001 ;
 	}
 _g = (_g - _rhs)/.001;
  _ion_ina += ina ;
#if CACHEVEC
  if (use_cachevec) {
	VEC_RHS(_ni[_iml]) -= _rhs;
  }else
#endif
  {
	NODERHS(_nd) -= _rhs;
  }
 
}
 
}

static void nrn_jacob(NrnThread* _nt, _Memb_list* _ml, int _type) {
double* _p; Datum* _ppvar; Datum* _thread;
Node *_nd; int* _ni; int _iml, _cntml;
#if CACHEVEC
    _ni = _ml->_nodeindices;
#endif
_cntml = _ml->_nodecount;
_thread = _ml->_thread;
for (_iml = 0; _iml < _cntml; ++_iml) {
 _p = _ml->_data[_iml];
#if CACHEVEC
  if (use_cachevec) {
	VEC_D(_ni[_iml]) += _g;
  }else
#endif
  {
     _nd = _ml->_nodelist[_iml];
	NODED(_nd) += _g;
  }
 
}
 
}

static void nrn_state(NrnThread* _nt, _Memb_list* _ml, int _type) {
double* _p; Datum* _ppvar; Datum* _thread;
Node *_nd; double _v = 0.0; int* _ni; int _iml, _cntml;
#if CACHEVEC
    _ni = _ml->_nodeindices;
#endif
_cntml = _ml->_nodecount;
_thread = _ml->_thread;
for (_iml = 0; _iml < _cntml; ++_iml) {
 _p = _ml->_data[_iml]; _ppvar = _ml->_pdata[_iml];
 _nd = _ml->_nodelist[_iml];
#if CACHEVEC
  if (use_cachevec) {
    _v = VEC_V(_ni[_iml]);
  }else
#endif
  {
    _nd = _ml->_nodelist[_iml];
    _v = NODEV(_nd);
  }
 v=_v;
{
  ena = _ion_ena;
 {   state(_p, _ppvar, _thread, _nt);
  } }}

}

static void terminal(){}

static void _initlists(){
 double _x; double* _p = &_x;
 int _i; static int _first = 1;
  if (!_first) return;
 _slist1[0] = mn_columnindex;  _dlist1[0] = Dmn_columnindex;
 _slist1[1] = hn_columnindex;  _dlist1[1] = Dhn_columnindex;
_first = 0;
}

#if defined(__cplusplus)
} /* extern "C" */
#endif

#if NMODL_TEXT
static const char* nmodl_filename = "Nav.mod";
static const char* nmodl_file_text = 
  "COMMENT\n"
  "Persistent TTX-resistant voltage-gated Na channel (Nav1.9)\n"
  "from Herzog et al., 2001.\n"
  "ENDCOMMENT\n"
  "\n"
  "NEURON{\n"
  "    SUFFIX TTXRNa\n"
  "    USEION na READ ena WRITE ina\n"
  "    RANGE gnabar, A_am9, B_am9, C_am9, A_bm9, B_bm9, C_bm9, A_ah9, B_ah9, C_ah9, A_bh9, B_bh9, C_bh9\n"
  "    RANGE mn, hn, ina\n"
  "}\n"
  "\n"
  "UNITS{\n"
  "    (S) = (siemens)\n"
  "    (mV) = (millivolt)\n"
  "    (mA) = (milliamp)\n"
  "}\n"
  "\n"
  "PARAMETER{\n"
  "    gnabar = 7.5e-5 (S/cm2)\n"
  "\n"
  "    A_am9 = 1.032 (/ms)\n"
  "	B_am9 = 6.99 (mV)\n"
  "	C_am9 = -14.87115 (mV)\n"
  "\n"
  "    A_bm9 = 5.79 (/ms)\n"
  "	B_bm9 = 130.4 (mV)\n"
  "	C_bm9 = 22.9 (mV)\n"
  "\n"
  "	A_ah9 = 0.06435 (/ms)\n"
  "	B_ah9 = 73.26415 (mV)\n"
  "	C_ah9 = 3.71928 (mV)\n"
  "\n"
  "    A_bh9 = 0.13496 (/ms)\n"
  "	B_bh9 = 10.27853 (mV)\n"
  "	C_bh9 = -9.09334 (mV)\n"
  "}\n"
  "\n"
  "ASSIGNED{\n"
  "    v (mV)\n"
  "    ena (mV)\n"
  "    ina (mA/cm2)\n"
  "    gna (S/cm2)\n"
  "    tau_mn (ms)\n"
  "    tau_hn (ms)\n"
  "    mninf\n"
  "    hninf\n"
  "}\n"
  "\n"
  "STATE{\n"
  "    mn\n"
  "    hn\n"
  "}\n"
  "\n"
  "INITIAL{\n"
  "    rates(v)\n"
  "    mn = mninf\n"
  "    hn = hninf\n"
  "}\n"
  "\n"
  "BREAKPOINT{\n"
  "    SOLVE state METHOD cnexp\n"
  "    ina = gnabar * mn * hn * (v - ena)\n"
  "}\n"
  "\n"
  "DERIVATIVE state{\n"
  "    rates(v)\n"
  "    mn' = (mninf - mn)/tau_mn\n"
  "	hn' = (hninf - hn)/tau_hn\n"
  "}\n"
  "\n"
  "FUNCTION alpham(Vm (mV)) (/ms) {\n"
  "	alpham = A_am9/(1+exp((Vm+B_am9)/C_am9))\n"
  "}\n"
  "\n"
  "FUNCTION betam(Vm (mV)) (/ms) {\n"
  "	betam = A_bm9/(1+exp((Vm+B_bm9)/C_bm9))\n"
  "}\n"
  "\n"
  "FUNCTION alphah(Vm (mV)) (/ms) {\n"
  "	alphah = A_ah9/(1+exp((Vm+B_ah9)/C_ah9))\n"
  "}\n"
  "\n"
  "FUNCTION betah(Vm (mV)) (/ms) {\n"
  "	betah = A_bh9/(1+exp((Vm+B_bh9)/C_bh9))\n"
  "}\n"
  "\n"
  "PROCEDURE rates(Vm (mV)){\n"
  "	tau_mn = 1.0 / (alpham(Vm) + betam(Vm))\n"
  "	mninf = alpham(Vm) * tau_mn\n"
  "\n"
  "	tau_hn = 1.0 / (alphah(Vm) + betah(Vm))\n"
  "	hninf = alphah(Vm) * tau_hn\n"
  "}\n"
  ;
#endif
