COMMENT
Persistent TTX-resistant voltage-gated Na channel (Nav1.9)
from Herzog et al., 2001.
ENDCOMMENT

NEURON{
    SUFFIX TTXRNa
    USEION na READ ena WRITE ina
    RANGE gnabar, A_am9, B_am9, C_am9, A_bm9, B_bm9, C_bm9, A_ah9, B_ah9, C_ah9, A_bh9, B_bh9, C_bh9
    RANGE mn, hn, ina
}

UNITS{
    (S) = (siemens)
    (mV) = (millivolt)
    (mA) = (milliamp)
}

PARAMETER{
    gnabar = 7.5e-5 (S/cm2)

    A_am9 = 1.032 (/ms)
	B_am9 = 6.99 (mV)
	C_am9 = -14.87115 (mV)

    A_bm9 = 5.79 (/ms)
	B_bm9 = 130.4 (mV)
	C_bm9 = 22.9 (mV)

	A_ah9 = 0.06435 (/ms)
	B_ah9 = 73.26415 (mV)
	C_ah9 = 3.71928 (mV)

    A_bh9 = 0.13496 (/ms)
	B_bh9 = 10.27853 (mV)
	C_bh9 = -9.09334 (mV)
}

ASSIGNED{
    v (mV)
    ena (mV)
    ina (mA/cm2)
    gna (S/cm2)
    tau_mn (ms)
    tau_hn (ms)
    mninf
    hninf
}

STATE{
    mn
    hn
}

INITIAL{
    rates(v)
    mn = mninf
    hn = hninf
}

BREAKPOINT{
    SOLVE state METHOD cnexp
    ina = gnabar * mn * hn * (v - ena)
}

DERIVATIVE state{
    rates(v)
    mn' = (mninf - mn)/tau_mn
	hn' = (hninf - hn)/tau_hn
}

FUNCTION alpham(Vm (mV)) (/ms) {
	alpham = A_am9/(1+exp((Vm+B_am9)/C_am9))
}

FUNCTION betam(Vm (mV)) (/ms) {
	betam = A_bm9/(1+exp((Vm+B_bm9)/C_bm9))
}

FUNCTION alphah(Vm (mV)) (/ms) {
	alphah = A_ah9/(1+exp((Vm+B_ah9)/C_ah9))
}

FUNCTION betah(Vm (mV)) (/ms) {
	betah = A_bh9/(1+exp((Vm+B_bh9)/C_bh9))
}

PROCEDURE rates(Vm (mV)){
	tau_mn = 1.0 / (alpham(Vm) + betam(Vm))
	mninf = alpham(Vm) * tau_mn

	tau_hn = 1.0 / (alphah(Vm) + betah(Vm))
	hninf = alphah(Vm) * tau_hn
}
