COMMENT
linear leak currents.
ENDCOMMENT

NEURON{
    SUFFIX leak
    USEION na READ ena WRITE ina
    USEION k READ ek WRITE ik
    USEION cl READ ecl WRITE icl VALENCE -1
    RANGE ina,ik,icl,gna, gk, gcl
}

UNITS{
    (S) = (siemens)
    (mV) = (millivolt)
    (mA) = (milliamp)
}

PARAMETER{
    gna = 0.50e-5 (S/cm2)
    gk = 4.0e-5 (S/cm2)
    gcl = 0.10e-5 (S/cm2)
}

ASSIGNED{
    v (mV)
    ena (mV)
    ina (mA/cm2)
    ek (mV)
    ik (mA/cm2)
    ecl (mV)
    icl (mA/cm2)
}

BREAKPOINT{
    ina = gna * (v - ena)
    ik = gk * (v - ek)
    icl = gcl * (v - ecl)
}